<?php

namespace App\Models\Frontend;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HeroSlide extends Model
{
    use HasFactory;

    protected $table = 'frontend_hero_slides';

    protected $fillable = [
        'title',
        'subtitle',
        'bg_image',
        'cta_primary',
        'cta_secondary',
        'cta_primary_url',
        'cta_secondary_url',
        'sort_order',
        'status',
        'active'
    ];

    protected $casts = [
        'sort_order' => 'integer',
        'active' => 'boolean'
    ];

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    public function scopePublished($query)
    {
        return $query->where('status', 'published');
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }

    // Accessors
    public function getBgImageUrlAttribute()
    {
        return asset($this->bg_image);
    }
} 