<?php

namespace App\Models\Frontend;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GalleryImage extends Model
{
    use HasFactory;

    protected $table = 'frontend_gallery_images';

    protected $fillable = [
        'src',
        'alt',
        'category',
        'edition',
        'height',
        'title',
        'description',
        'photographer',
        'date_taken',
        'status',
        'sort_order',
        'featured'
    ];

    protected $casts = [
        'height' => 'integer',
        'sort_order' => 'integer',
        'featured' => 'boolean',
        'date_taken' => 'date'
    ];

    // Scopes
    public function scopeByCategory($query, $category)
    {
        if ($category && $category !== 'all') {
            return $query->where('category', $category);
        }
        return $query;
    }

    public function scopeByEdition($query, $edition)
    {
        if ($edition && $edition !== 'all') {
            return $query->where('edition', $edition);
        }
        return $query;
    }

    public function scopeFeatured($query)
    {
        return $query->where('featured', true);
    }

    public function scopePublished($query)
    {
        return $query->where('status', 'published');
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order')->orderBy('created_at', 'desc');
    }

    // Static methods for categories and editions
    public static function getCategories()
    {
        return [
            'all' => 'All Photos',
            'matches' => 'Matches',
            'celebrations' => 'Celebrations',
            'awards' => 'Awards',
            'venues' => 'Venues',
            'training' => 'Training',
            'fans' => 'Fans',
            'teams' => 'Teams'
        ];
    }

    public static function getEditions()
    {
        return [
            'all' => 'All Editions',
            '1st' => '1st Edition',
            '2nd' => '2nd Edition',
            '3rd' => '3rd Edition',
            '4th' => '4th Edition'
        ];
    }

    // Helper methods
    public function getFullUrlAttribute()
    {
        return asset($this->src);
    }
} 