<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Formation extends Model
{
    protected $fillable = [
        'name',
        'display_name',
        'description',
        'positions',
        'category',
        'is_popular',
        'is_active',
        'country',
    ];

    protected $casts = [
        'positions' => 'array',
        'is_popular' => 'boolean',
        'is_active' => 'boolean',
    ];

    public function teamFormations(): HasMany
    {
        return $this->hasMany(TeamFormation::class);
    }

    public function scopePopular($query)
    {
        return $query->where('is_popular', true);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByCategory($query, $category)
    {
        return $query->where('category', $category);
    }

    public function scopeByCountry($query, $country)
    {
        return $query->where('country', $country);
    }
}
