<?php

namespace App\Mail;

use App\Models\TeamOfficial;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class OfficialOtpMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $official;
    public $otp;

    /**
     * Create a new message instance.
     */
    public function __construct(TeamOfficial $official, string $otp)
    {
        $this->official = $official;
        $this->otp = $otp;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Verification Code - Team Official',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.officials.otp',
            with: [
                'official' => $this->official,
                'team' => $this->official->team,
                'otp' => $this->otp,
                'expiresAt' => $this->official->otp_expires_at,
                'verificationUrl' => route('officials.verify', ['official' => $this->official->id]),
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}