<?php

namespace App\Mail;

use App\Models\TeamOfficial;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class OfficialAssignmentMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $official;

    /**
     * Create a new message instance.
     */
    public function __construct(TeamOfficial $official)
    {
        $this->official = $official;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Team Official Assignment - ' . $this->official->team->name,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.officials.assignment',
            with: [
                'official' => $this->official,
                'team' => $this->official->team,
                'verificationUrl' => route('officials.verify', ['official' => $this->official->id]),
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}