<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdatePlayerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => 'sometimes|required|exists:users,id',
            'tournament_id' => 'sometimes|required|exists:tournaments,id',
            'display_name' => 'sometimes|required|string|max:255',
            'bio' => 'nullable|string',
            'avatar' => 'nullable|string',
            'stats' => 'nullable|array',
            'status' => 'sometimes|required|in:registered,active,eliminated,withdrawn',
        ];
    }
}
