<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateGameMatchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'tournament_id' => 'sometimes|required|exists:tournaments,id',
            'bracket_id' => 'nullable|exists:brackets,id',
            'round' => 'sometimes|required|integer|min:1',
            'match_number' => 'sometimes|required|integer|min:1',
            'player1_id' => 'nullable|exists:players,id',
            'player2_id' => 'nullable|exists:players,id',
            'team1_id' => 'nullable|exists:teams,id',
            'team2_id' => 'nullable|exists:teams,id',
            'player1_score' => 'nullable|integer|min:0',
            'player2_score' => 'nullable|integer|min:0',
            'winner_id' => 'nullable|exists:players,id',
            'winning_team_id' => 'nullable|exists:teams,id',
            'status' => 'sometimes|required|in:scheduled,in_progress,completed,cancelled',
            'scheduled_time' => 'nullable|date',
            'started_at' => 'nullable|date',
            'completed_at' => 'nullable|date',
        ];
    }
}
