<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBracketRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'tournament_id' => 'required|exists:tournaments,id',
            'name' => 'required|string|max:255',
            'type' => 'required|in:winners,losers,final',
            'rounds' => 'required|integer|min:1',
            'structure' => 'nullable|array',
            'seeding' => 'nullable|array',
            'is_active' => 'required|boolean',
        ];
    }
}
