<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsureProfileComplete
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();
        
        if (!$user) {
            return redirect()->route('login');
        }
        
        // Skip profile completion check for certain routes
        $excludedRoutes = [
            'profile.complete',
            'profile.complete.update',
            'logout',
            'password.change.*'
        ];
        
        foreach ($excludedRoutes as $excludedRoute) {
            if ($request->routeIs($excludedRoute)) {
                return $next($request);
            }
        }
        
        // Check if user must change password first
        if ($user->must_change_password) {
            return redirect()->route('password.change.verify');
        }
        
        // Check if profile is incomplete
        if (!$user->profile_complete) {
            return redirect()->route('profile.complete')
                ->with('message', 'Please complete your profile to continue.');
        }
        
        return $next($request);
    }
}
