<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsurePaymentComplete
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();
        
        if (!$user) {
            return redirect()->route('login');
        }
        
        // Skip payment check for certain routes
        $excludedRoutes = [
            'profile.complete',
            'profile.complete.update',
            'payment.required',
            'payment.initiate',
            'payment.status',
            'payment.history',
            'payment.retry',
            'logout',
            'password.change.*'
        ];
        
        foreach ($excludedRoutes as $excludedRoute) {
            if ($request->routeIs($excludedRoute)) {
                return $next($request);
            }
        }
        
        // Check if user must change password first
        if ($user->must_change_password) {
            return redirect()->route('password.change.verify');
        }
        
        // Check if profile is incomplete
        if (!$user->profile_complete) {
            return redirect()->route('profile.complete');
        }
        
        // Check if payment is incomplete
        if ($user->payment_status !== 'completed') {
            return redirect()->route('payment.required')
                ->with('message', 'Payment is required to access the tournament system.');
        }
        
        return $next($request);
    }
}
