<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class ApplySettings
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Share settings with all views
        View::share('appSettings', [
            'name' => config('app.name'),
            'description' => config('app.description'),
            'logo' => config('app.logo'),
            'favicon' => config('app.favicon'),
            'contact_email' => config('app.contact_email'),
            'meta_title' => config('app.meta_title'),
            'meta_description' => config('app.meta_description'),
            'meta_keywords' => config('app.meta_keywords'),
            'og_image' => config('app.og_image'),
        ]);

        return $next($request);
    }
}