<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Player;
use App\Models\Tournament;

class PlayerController extends Controller
{
    public function register()
    {
        $tournaments = Tournament::where('status', 'active')
            ->select('id', 'name', 'start_date', 'end_date')
            ->get();

        return Inertia::render('frontend/PlayerRegister', [
            'tournaments' => $tournaments
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'display_name' => 'required|string|max:255',
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:players,email',
            'phone' => 'nullable|string|max:20',
            'date_of_birth' => 'required|date',
            'tournament_id' => 'required|exists:tournaments,id',
            'skill_level' => 'required|in:beginner,intermediate,advanced,professional',
        ]);

        Player::create([
            'display_name' => $request->display_name,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'phone' => $request->phone,
            'date_of_birth' => $request->date_of_birth,
            'tournament_id' => $request->tournament_id,
            'skill_level' => $request->skill_level,
            'status' => 'registered',
        ]);

        return redirect()->back()->with('success', 'Player registration successful! You will receive a confirmation email shortly.');
    }
} 