<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;
use Inertia\Response;

class QueueMonitorController extends Controller
{
    public function index(): Response
    {
        // Pending jobs (queued)
        $pendingJobs = DB::table('jobs')
            ->select('id', 'queue', 'attempts', 'reserved_at', 'available_at', 'created_at')
            ->orderByDesc('id')
            ->limit(100)
            ->get()
            ->map(function ($job) {
                return [
                    'id' => $job->id,
                    'queue' => $job->queue,
                    'attempts' => $job->attempts,
                    'reserved_at' => $job->reserved_at,
                    'available_at' => $job->available_at,
                    'created_at' => $job->created_at,
                ];
            });

        // Failed jobs
        $failedJobs = DB::table('failed_jobs')
            ->select('id', 'uuid', 'connection', 'queue', 'exception', 'failed_at')
            ->orderByDesc('id')
            ->limit(100)
            ->get();

        // Batches (executed/pending overview)
        $jobBatches = DB::table('job_batches')
            ->select('id', 'name', 'total_jobs', 'pending_jobs', 'failed_jobs', 'created_at', 'finished_at')
            ->orderByDesc('created_at')
            ->limit(100)
            ->get();

        // Notifications sent (database channel)
        $notifications = DB::table('notifications')
            ->select('id', 'type', 'notifiable_type', 'notifiable_id', 'data', 'read_at', 'created_at')
            ->orderByDesc('created_at')
            ->limit(100)
            ->get()
            ->map(function ($n) {
                return [
                    'id' => $n->id,
                    'type' => $n->type,
                    'notifiable_type' => $n->notifiable_type,
                    'notifiable_id' => $n->notifiable_id,
                    'data' => json_decode($n->data, true),
                    'read_at' => $n->read_at,
                    'created_at' => $n->created_at,
                ];
            });

        return Inertia::render('admin/QueueMonitor', [
            'pendingJobs' => $pendingJobs,
            'failedJobs' => $failedJobs,
            'jobBatches' => $jobBatches,
            'notifications' => $notifications,
        ]);
    }
}
