<?php

namespace App\Helpers;

class ToastHelper
{
    /**
     * Show a success toast message
     */
    public static function success(string $message): \Illuminate\Http\RedirectResponse
    {
        return redirect()->back()->with('success', $message);
    }

    /**
     * Show an error toast message
     */
    public static function error(string $message): \Illuminate\Http\RedirectResponse
    {
        return redirect()->back()->with('error', $message);
    }

    /**
     * Show a warning toast message
     */
    public static function warning(string $message): \Illuminate\Http\RedirectResponse
    {
        return redirect()->back()->with('warning', $message);
    }

    /**
     * Show an info toast message
     */
    public static function info(string $message): \Illuminate\Http\RedirectResponse
    {
        return redirect()->back()->with('info', $message);
    }

    /**
     * Show a success toast message and redirect to a specific route
     */
    public static function successToRoute(string $route, string $message, array $parameters = []): \Illuminate\Http\RedirectResponse
    {
        return redirect()->route($route, $parameters)->with('success', $message);
    }

    /**
     * Show an error toast message and redirect to a specific route
     */
    public static function errorToRoute(string $route, string $message, array $parameters = []): \Illuminate\Http\RedirectResponse
    {
        return redirect()->route($route, $parameters)->with('error', $message);
    }

    /**
     * Show a warning toast message and redirect to a specific route
     */
    public static function warningToRoute(string $route, string $message, array $parameters = []): \Illuminate\Http\RedirectResponse
    {
        return redirect()->route($route, $parameters)->with('warning', $message);
    }

    /**
     * Show an info toast message and redirect to a specific route
     */
    public static function infoToRoute(string $route, string $message, array $parameters = []): \Illuminate\Http\RedirectResponse
    {
        return redirect()->route($route, $parameters)->with('info', $message);
    }
}
