<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Queue worker - runs every minute and stops when empty (crucial for shared hosting)
        // Process queues in priority order: high, default, low
        $schedule->command('queue:work --stop-when-empty --queue=high,default,low --timeout=120 --tries=3')
                ->everyMinute()
                ->withoutOverlapping()
                ->runInBackground();

        // Restart queue workers daily to prevent memory leaks
        $schedule->command('queue:restart')
                ->daily()
                ->at('02:00');

        // Clean up failed jobs older than 7 days
        $schedule->command('queue:prune-failed --hours=168')
                ->daily()
                ->at('03:00');

        // Clean up batches older than 7 days
        $schedule->command('queue:prune-batches --hours=168')
                ->daily()
                ->at('03:30');

        // Clear application cache weekly
        $schedule->command('cache:clear')
                ->weekly()
                ->at('04:00');

        // Clear config cache weekly
        $schedule->command('config:clear')
                ->weekly()
                ->at('04:30');

        // Clear route cache weekly
        $schedule->command('route:clear')
                ->weekly()
                ->at('05:00');

        // Clear view cache weekly
        $schedule->command('view:clear')
                ->weekly()
                ->at('05:30');
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
