<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\NotificationRegistryService;

class SyncNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notifications:sync';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Scan notification classes and sync to database';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Scanning notification classes...');

        $registryService = new NotificationRegistryService();
        $result = $registryService->syncNotifications();

        $this->info("\n✅ Notification settings synced successfully!");
        $this->info("━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━");
        $this->info("📊 Total notifications: {$result['total']}");
        $this->info("➕ Created: {$result['created']}");
        $this->info("🔄 Updated: {$result['updated']}");
        
        // Show breakdown by category
        $counts = $registryService->getCategoryCounts();
        $this->info("\n📁 Breakdown by category:");
        foreach ($counts as $category => $count) {
            $this->info("  - " . ucfirst($category) . ": {$count}");
        }

        $this->info("\n✨ Cache cleared and settings are now active.");

        return Command::SUCCESS;
    }
}

