<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Helpers\StorageHelper;

class StorageSyncCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'storage:sync';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync files from storage/app/public to public/storage';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Syncing storage files...');

        $result = StorageHelper::syncPublicStorage();

        if ($result) {
            $this->info('✓ Storage files synced successfully');
        } else {
            $this->error('✗ Failed to sync storage files');
        }

        $this->info('Storage sync completed!');
    }
}