<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Helpers\StorageHelper;

class StorageSetupCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'storage:setup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Setup public storage directory';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Setting up storage directories...');

        $result = StorageHelper::setupPublicStorage();

        if ($result['public_storage_created']) {
            $this->info('✓ Public storage directory created');
        } else {
            $this->info('✓ Public storage directory already exists');
        }

        if ($result['storage_app_public_created']) {
            $this->info('✓ Storage app/public directory created');
        } else {
            $this->info('✓ Storage app/public directory already exists');
        }

        if ($result['public_storage_writable']) {
            $this->info('✓ Public storage directory is writable');
        } else {
            $this->error('✗ Public storage directory is not writable');
        }

        if ($result['storage_app_public_writable']) {
            $this->info('✓ Storage app/public directory is writable');
        } else {
            $this->error('✗ Storage app/public directory is not writable');
        }

        $this->info('Storage setup completed!');
    }
}