<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Helpers\StorageHelper;

class StorageCleanupCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'storage:cleanup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean up old files in public storage';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Cleaning up storage files...');

        $result = StorageHelper::cleanupPublicStorage();

        if ($result) {
            $this->info('✓ Storage cleanup completed successfully');
        } else {
            $this->error('✗ Failed to cleanup storage files');
        }

        $this->info('Storage cleanup completed!');
    }
}