<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Database\Seeders\TeamPermissionsSeeder;

class SeedTeamPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seed:team-permissions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Seed team permissions for the admin system';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Seeding team permissions...');
        
        $seeder = new TeamPermissionsSeeder();
        $seeder->run();
        
        $this->info('Team permissions seeded successfully!');
        
        return Command::SUCCESS;
    }
}
